clear all
close all
clc
%% ECCENTRICO 1000 rpm
open('1000rpm_eccentrico.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('piattoB_1000_e.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
%
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 90, y1,'-r')
grid on
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('PLATE B - 1000 RPM, eccentric rotors')
xlim([0, 360])

%% CENTRATO
open('1000rpm_centrato.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('piattoB_1000_c.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
%
figure(2000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 87, y1,'-r')
grid on
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('PLATE B - 1000 RPM, centered rotors')
xlim([0, 360])

%% CONFRONTO CON CUSCINETTO
open('piattoB_1000_e_bear.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('piattoB_1000_e.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
%
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x1, 1)
    plot(x1{ii,:},y1{ii,:}*1e-5, '-r', 'linewidth', 2)
    hold on
end
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':b', 'linewidth', 2)
    hold on
end
hold off
grid on
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('PLATE B - 1000 RPM')
xlim([0, 210])
